// main.c
//
// Author(s):
// 	Erasme <support@erasme.org>
//
// Copyright (c) 2008-2010 Departement du Rhone
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
//

#include <stdio.h>
#include <cv.h>
#include <highgui.h>

int main (int argc, char *argv[])
{
	int i;
	int i2;
	int i3 = 0;
	int numImages;
	int* numPoints;
	float cameraMatrix[3*3];
    float distortion[4];
    float* transVects;
    float* rotMatrs;
    IplImage* image;
    CvPoint2D32f* imagePoints;
  
    CvPoint3D32f* objectPoints;
  
	CvPoint3D32f refObjectPoints[35] = {
{         0,   10.1600,         0},
{    2.5400,   10.1600,         0},
{    5.0800,   10.1600,         0},
{    7.6200,   10.1600,         0},
{   10.1600,   10.1600,         0},
{   12.7000,   10.1600,         0},
{   15.2400,   10.1600,         0},
{         0,    7.6200,         0},
{    2.5400,    7.6200,         0},
{    5.0800,    7.6200,         0},
{    7.6200,    7.6200,         0},
{   10.1600,    7.6200,         0},
{   12.7000,    7.6200,         0},
{   15.2400,    7.6200,         0},
{         0,    5.0800,         0},
{    2.5400,    5.0800,         0},
{    5.0800,    5.0800,         0},
{    7.6200,    5.0800,         0},
{   10.1600,    5.0800,         0},
{   12.7000,    5.0800,         0},
{   15.2400,    5.0800,         0},
{         0,    2.5400,         0},
{    2.5400,    2.5400,         0},
{    5.0800,    2.5400,         0},
{    7.6200,    2.5400,         0},
{   10.1600,    2.5400,         0},
{   12.7000,    2.5400,         0},
{   15.2400,    2.5400,         0},
{         0,         0,         0},
{    2.5400,         0,         0},
{    5.0800,         0,         0},
{    7.6200,         0,         0},
{   10.1600,         0,         0},
{   12.7000,         0,         0},
{   15.2400,         0,         0},
	};
  
    CvSize pattern_size = cvSize(7, 5);
	int corner_count = 0;
	CvPoint2D32f* corners;
	CvSize imageSize;
	
	numImages = argc-1;
	numPoints = (int*)cvAlloc(numImages * sizeof(int));
	transVects = (float*)cvAlloc(3 * 1 * numImages * sizeof(float));
    rotMatrs   = (float*)cvAlloc(3 * 3 * numImages * sizeof(float));
	corners = (CvPoint2D32f*)cvAlloc(5 * 7 * sizeof(CvPoint2D32f));
	imagePoints = (CvPoint2D32f*)cvAlloc(5 * 7 *  numImages * sizeof(CvPoint2D32f));
    objectPoints = (CvPoint3D32f*)cvAlloc(5 * 7 *  numImages * sizeof(CvPoint3D32f));

	for(i = 1; i < argc; i++) {
		printf("file %s\n", argv[i]);
		image = cvLoadImage(argv[i], CV_LOAD_IMAGE_GRAYSCALE);
		
		if(cvFindChessboardCorners(image, pattern_size, corners, &corner_count, CV_CALIB_CB_ADAPTIVE_THRESH)) {
			printf("Corner found = %d\n", corner_count);
		}
		else {
			printf("Fails to find corners %d\n", corner_count);
		}
		numPoints[i-1] = corner_count;
		for(i2 = 0; i2 < corner_count; i2++) {
			printf("%4f %4f\n", corners[i2].x, corners[i2].y);
			imagePoints[i3].x = corners[i2].x;
			imagePoints[i3].y = corners[i2].y;
			
			objectPoints[i3].x = refObjectPoints[i2].x;
			objectPoints[i3].y = refObjectPoints[i2].y;
			objectPoints[i3].z = refObjectPoints[i2].z;
			
			i3++;
		}
		imageSize.width = image->width;
		imageSize.height = image->height;
		
		cvReleaseImage(&image);
	}
	
	printf("Image size %d x %d\n", imageSize.width, imageSize.height);

	cvCalibrateCamera(numImages, numPoints, imageSize, imagePoints, objectPoints,
		distortion, cameraMatrix, transVects, rotMatrs, 0);

    printf("Distortion: [k1 = %f, k2 = %f, p1 = %f, p2 = %f]\n", distortion[0], distortion[1], distortion[2], distortion[3]);

	printf("Camera Matrix:\n");
	i3 = 0;
    for(i = 0; i < 3; i++) {
	    printf("{");
	    for(i2 = 0; i2 < 3; i2++, i3++) {
		    printf("%10.5f", cameraMatrix[i3]);
		    if(i2 != 2)
		    	printf(", ");
	    }
	    printf("}\n");
    }

/*
	cvCalibrateCamera2( const CvMat* object_points,
                                const CvMat* image_points,
                                const CvMat* point_counts,
                                CvSize image_size,
                                CvMat* intrinsic_matrix,
                                CvMat* distortion_coeffs,
                                CvMat* rotation_vectors CV_DEFAULT(NULL),
                                CvMat* translation_vectors CV_DEFAULT(NULL),
                                0);
*/
/*
	cvCalibrateCamera_64d(numImages, numPoints, CvSize imageSize,
    	CvPoint2D64d* imagePoints, CvPoint3D64d* objectPoints, 
	    distortion, cameraMatrix, transVects, rotMatrs, 0);
*/
	cvFree(&transVects);
	cvFree(&rotMatrs);
	cvFree(&numPoints);
	
	return 0;
}
