// main.c
//
// Author(s):
// 	Erasme <support@erasme.org>
//
// Copyright (c) 2008-2010 Departement du Rhone
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
//
 
#include <stdio.h>
#include <locale.h>
#include <stdlib.h>
#include <cv.h>

int main (int argc, char *argv[])
{
	float matrix[3*3] = {0,0,0,0,0,0,0,0,0};
	CvMat *src;
	CvMat *dst;
	int nb_val = 0;
	int i, i2;
	CvMat cv_matrix = cvMat( 3, 3, CV_32FC1, matrix);
	
	if(argc != 3) {
		printf("Usage: transmatrix source dst\nex: transmatrix 0,0;0,1;1,1 0,0;0,480;640,480");
		exit(1);
	}
	
	for(i = 0; argv[1][i]; i++) {
		if(argv[1][i] == ';') {
			nb_val++;
		}
	}
	nb_val++;
	
	src = cvCreateMat(nb_val, 2, CV_32FC1);
	dst = cvCreateMat(nb_val, 2, CV_32FC1);
	
	setlocale (LC_NUMERIC, "C");

	for(i = 0, i2 = 0; argv[1][i];) {
		src->data.fl[i2++] = (float)atof(&(argv[1][i]));
		while(argv[1][i] && (argv[1][i] != ',')) { i++; }
		if(argv[1][i] == ',') i++;
		src->data.fl[i2++] = (float)atof(&(argv[1][i]));
		while(argv[1][i] && (argv[1][i] != ';')) { i++; }
		if(argv[1][i] == ';') i++;
	}

	for(i = 0, i2 = 0; argv[2][i];) {
		dst->data.fl[i2++] = (float)atof(&(argv[2][i]));
		while(argv[2][i] && (argv[2][i] != ',')) { i++; }
		if(argv[2][i] == ',') i++;
		dst->data.fl[i2++] = (float)atof(&(argv[2][i]));
		while(argv[2][i] && (argv[2][i] != ';')) { i++; }
		if(argv[2][i] == ';') i++;
	}

	for(i = 0; i < nb_val; i++) {
		printf("SRC: (%f, %f)\n", src->data.fl[i*2], src->data.fl[i*2+1]);
	}

	for(i = 0; i < nb_val; i++) {
		printf("DST: (%f, %f)\n", dst->data.fl[i*2], dst->data.fl[i*2+1]);
	}
	
	cvFindHomography(src, dst, &cv_matrix, 0, 0, 0);

	printf("Homography Matrix:\n");

	for(i2 = 0; i2 < 3; i2++) {
		for(i = 0; i < 3; i++) {
			printf("%12.5f", matrix[i2*3+i]);
			if(i != 2) {
				printf(", ");
			}
		}
		printf("\n");
	}
	

	cvReleaseMat(&src);
	cvReleaseMat(&dst);

	return 0;
}
