/*
 Kalman filter class.
 
 Derived from information found at Marcus' site.
 http://interactive-matter.org/2009/12/filtering-sensor-data-with-a-kalman-filter/
 
 Copyright (c) 2010 Marcus / Michel Blanc
 
 Permission is hereby granted, free of charge, to any person
 obtaining a copy of this software and associated documentation
 files (the "Software"), to deal in the Software without
 restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following
 conditions:

 The above copyright notice and this permission notice shall be
 included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 OTHER DEALINGS IN THE SOFTWARE.

If you want you may contact me at mblanc@erasme.org
or on jabber: leucos@jabber.org
*/


public class Kalman {
  float q; //process noise covariance
  float r; //measurement noise covariance
  float x; //value
  float p; //estimation error covariance
  float k; //kalman gain

  public Kalman(float nq, float nr, float np, float initial_value) {
      q = nq;
      r = nr;
      p = np;
      x = initial_value;
  }

  public float Update(float value) {
    p = p + q;
    
    k = p / (p + r);
    x = x + k * (value - x);
    p = (1 - k) * p;
    
    return x;
  }
  
  public float Value() {
    return x;
  }
  
  public void setQ(float newQ) {
    q = newQ;
    println ("Q is now " + q);    
  }
  
  public void setR(float newR) {
    r = newR;
    println ("R is now " + r);    
  }  
}
