import processing.serial.*;
import java.awt.Robot;
import java.awt.event.KeyEvent;

import oscP5.*;
import netP5.*; 


Robot robot;
OscP5 oscP5;

/* a NetAddress contains the ip address and port number of a remote location in the network. */NetAddress myBroadcastLocation; 

PFont font;

Serial port;
String portname = "/dev/ttyUSB0";  

String oscroot="/erasme/globe/2/wiimote/0";

//String portname = "/dev/rfcomm2";  
int baudrate = 9600;
int serialValue;

int ileft = 0;
int iright = 1;  
int iup = 2;
int idown = 3;
int iplus = 4;
int iminus = 5;
int ia = 6;
int ib = 7;
int ione = 8;
int itwo = 9;
int ihome = 10;

int alt = 0;
int ctrl = 1;
int shift = 2;

int[] wii_axis = new int[3];
int[] axis = new int[3];
int[] axis_way = new int[3];
boolean mousepress = false;
int[] axis_offset = {-130, -130, -159};
int mouseOffX=0;
int mouseOffY=0;
int lastmouse;

int ytrigger = 30;
int yspintrigger = 100;

boolean cab_sequence_init = false;

int[] wii_states = new int[ihome+1];

int[] states = new int[ihome+1];

int[][] modifiers = { {0,0,0,0,0,0,0,0,0,0,0}, //alt
                      {0,0,0,0,1,1,0,0,0,0,0}, //ctrl
                      {0,0,0,0,0,0,1,1,1,1,0}};//shift
                      
int[] modifiercodes = {KeyEvent.VK_ALT, KeyEvent.VK_CONTROL, KeyEvent.VK_SHIFT};
String[] modifiernames = {"ALT", "CTRL", "SHIFT"};

String[] keynames = {"left","right","up","down","plus","minus","a","b","one","two","home"}; 

int[] keycodes =  { KeyEvent.VK_LEFT,  // left
                    KeyEvent.VK_RIGHT, // right
                    KeyEvent.VK_UP,    // up
                    KeyEvent.VK_DOWN,  // down
                    KeyEvent.VK_UP,    // plus
                    KeyEvent.VK_DOWN,  // minus
                    KeyEvent.VK_UP,     // a
                    KeyEvent.VK_DOWN,  // b
                    KeyEvent.VK_LEFT,    // one
                    KeyEvent.VK_RIGHT,  // two
                    KeyEvent.VK_N      // home
                  };

boolean DEBUG = true;

//Stack lifo = new Stack();

void send_ctrl_alt_backspace() 
{
  println("Got Ctrl-Alt-Backspace code");
  robot.keyPress(KeyEvent.VK_CONTROL);
  robot.keyPress(KeyEvent.VK_ALT);
  robot.keyPress(KeyEvent.VK_BACK_SPACE);
  robot.keyPress(KeyEvent.VK_BACK_SPACE);  
  robot.keyPress(KeyEvent.VK_ALT);  
  robot.keyPress(KeyEvent.VK_CONTROL);
}

void setup() 
{ 
  //size(screen.width, screen.height, P3D); 
  noStroke(); 
  noCursor(); 
  colorMode(RGB,1);
  
  //tex = loadImage("rhone.jpg");
  //textureMode(NORMALIZED);
  
  /*port = new Serial(this, portname, baudrate);
  println(port);*/
  
  font = loadFont("Univers45.vlw.gz"); 
  textFont(font, 64); 
  
  lastmouse = millis();
  
  // modifiers = new Integer[3];
  /* create a new instance of oscP5. 
  * 1234 is the port number you are listening for incoming osc messages.
  */
  oscP5 = new OscP5(this,1234);
  
  /* create a new NetAddress. a NetAddress is used when sending osc messages
   * with the oscP5.send method.
   */
  
  /* the address of the osc broadcast server */
  myBroadcastLocation = new NetAddress("127.0.0.1",1235);

  try {
    robot = new Robot();
    //press_alt_tab();
  } catch (Exception e) {
    println("Oops, something went wrong.");
  }
  

}

void notifyMoved() {
 /* create a new OscMessage with an address pattern, in this case /test. */
  OscMessage myOscMessage = new OscMessage(oscroot + "/keyevent");
  /* add a value (an integer) to the OscMessage */
  myOscMessage.add(1);
  /* send the OscMessage to a remote location specified in myNetAddress */
  oscP5.send(myOscMessage, myBroadcastLocation);
}

void oscEvent(OscMessage theOscMessage) {
  //println("Got osc message");
  /* get and print the address pattern and the typetag of the received OscMessage */
  if(theOscMessage.checkAddrPattern(oscroot + "/state")==true) {
    /* check if the typetag is the right one. */
    if(theOscMessage.checkTypetag("iiiiiiiiiii")) {
      cab_sequence_init = false;
      /* parse theOscMessage and extract the values from the osc message arguments. */
      /* we also check for the Ctrl-Alt-Backspace (home+A) sequence now */
      for(int i=0; i<=ihome; i=i+1) {
        wii_states[i] = theOscMessage.get(i).intValue();
        if (i==6 && wii_states[i]==1) 
          cab_sequence_init = true;
        else if (cab_sequence_init && i==10 && wii_states[i]==1)
          send_ctrl_alt_backspace();
      }
      
      for (int i=0; i<=ihome; i=i+1) {
        if (wii_states[i]==1) {
          for (int m=alt; m<=shift; m=m+1) {
            if (states[i] != 1 && modifiers[m][i] == 1) {
              println("pressing modifier "+modifiernames[m]);
              robot.keyPress(modifiercodes[m]);
            }
          }
          println("pressing "+keynames[i]);
          robot.keyPress(keycodes[i]);
          notifyMoved();
          states[i] = 1;
        } else if (states[i] == 1) {
          println("releasing "+keynames[i]); 
          states[i]=0;
          robot.keyRelease(keycodes[i]);
          for (int m=alt; m<=shift; m=m+1) {
            if (modifiers[m][i] == 1) {
              robot.keyRelease(modifiercodes[m]);
              println("releasing modifier "+modifiernames[m]); 
            }
          }
        }
      }
    }
  } else if (theOscMessage.checkAddrPattern(oscroot + "/accel")==true) {
    if (theOscMessage.checkTypetag("iii")) {
      for(int i=0; i<3; i=i+1) {
        wii_axis[i] = theOscMessage.get(i).intValue() + axis_offset[i];

        // low pass filter
        if ((wii_axis[i] < 50) && (wii_axis[i] > -50)) {
          wii_axis[i] = 0;
        }
        
        // backscatter suppression
        if (axis_way[i] * wii_axis[i] < 0) {
            wii_axis[i] = 0;
        }
      }
      
      if ((wii_axis[1] >= ytrigger) && (mousepress!=true) && (lastmouse + 500 < millis())) {
        mouseOffX=screen.width/2;
        mouseOffY=screen.height/2;        
        robot.mouseMove(mouseOffX, mouseOffY);

        robot.mousePress(InputEvent.BUTTON1_MASK);
        println(wii_axis[1]+" > "+ytrigger+" => mouse press");
        mousepress = true;
        
/*        PointerInfo pointer = MouseInfo.getPointerInfo();
        Point location = pointer.getLocation(); 
        println("La souris se trouve en "+location); */
      } else if ((wii_axis[1] < ytrigger) && (mousepress==true)) {
        robot.mouseRelease(InputEvent.BUTTON1_MASK);
        println(wii_axis[1]+" < "+ytrigger+" => mouse release");
        mousepress = false;
        mouseOffX=screen.width/2;
        mouseOffY=screen.height/2;        
        robot.mouseMove(mouseOffX, mouseOffY);
        axis_way[0]=0;
        axis_way[2]=0;
        lastmouse = millis();
      }
        
      if (mousepress == true) {
        
        if (axis_way[0]==0 && wii_axis[0] != 0) {
          axis_way[0] = abs(wii_axis[0]) / wii_axis[0];
        };

        if (axis_way[2]==0 && wii_axis[2] != 0) {
          axis_way[2] = abs(wii_axis[2]) / wii_axis[2];
        };
        
        mouseOffX -= wii_axis[0];
        mouseOffY -= wii_axis[2];

        int newX = mouseOffX;
        int newY = mouseOffY;
        if ((newX < screen.width) && (newY < screen.height)) {
          println("X "+wii_axis[0]+",Y"+wii_axis[2]+" => moving to ("+newX+","+newY+")");
          robot.mouseMove( newX, newY);
        } else {
          println("X "+wii_axis[0]+",Y"+wii_axis[2]+" => Mouse out of range");
        }
        lastmouse = millis();
      }
      
      for(int i=0; i<3; i=i+1) {
        axis[i] = wii_axis[i];
      }
    }
  } else if (theOscMessage.checkAddrPattern(oscroot + "/reload")==true) {
     if (theOscMessage.checkTypetag("i")) {
       println("Sending reload");
       robot.keyPress(modifiercodes[1]);
       robot.keyPress(KeyEvent.VK_R);
       robot.keyRelease(KeyEvent.VK_R);
       robot.keyRelease(modifiercodes[1]);
     }
  }
}

void draw() 
{
  /* Prepare GE */
  delay(1000);
    
  /* Select network link */
  robot.mouseMove(63,333);
  robot.mousePress(InputEvent.BUTTON1_MASK);
  robot.mouseRelease(InputEvent.BUTTON1_MASK);  
  
  delay(2000);
    
  /* Go full screen */
  robot.keyPress(KeyEvent.VK_F11);
  robot.keyRelease(KeyEvent.VK_F11);
  
  delay(2000);
  
  /* give focus to window */
  robot.mouseMove(63,333);  
  robot.mousePress(InputEvent.BUTTON1_MASK);
  robot.mouseRelease(InputEvent.BUTTON1_MASK);  
  
  noLoop();
} 
